package com.elitesland.fin.dto.invoice;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author sunxw
 * @description 开票配置
 * @Date 2023/7/17
 */
@Data
public class InvoiceRuleConfigRpcDTO implements Serializable {

    private Long id;

    @ApiModelProperty("开票规则码")
    private String ruleCode;

    @ApiModelProperty("开票规则名称")
    private String ruleName;

    @ApiModelProperty("适用单据 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String optDocCls;
    @ApiModelProperty("来源单据名称")
    private String optDocClsName;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    @ApiModelProperty("启用状态名称")
    private String statusName;

    @ApiModelProperty("来源单据类型 [UDC]yst-supp:DOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "DOC_TYPE")
    private String optDocType;
    @ApiModelProperty("来源单据类型名称")
    private String optDocTypeName;

    @ApiModelProperty("可开票单据状态 [UDC]yst-franchisee:PAYMENT_STATUS")
    @SysCode(sys = "yst-franchisee", mod = "PAYMENT_STATUS")
    private String optDocStatus;
    @ApiModelProperty("可开票单据状态名称")
    private String optDocStatusName;

    @ApiModelProperty("可开票时限（天）")
    private Integer invoiceLimit;

    @ApiModelProperty(value = "是否自动开票 1-是 0-否")
    private Integer autoInvoice;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    private Integer autoReview;

}
