package com.elitesland.fin.service.creditaccountflow;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.flow.AccountFlowRpcDTO;
import com.elitesland.fin.param.creditaccountflow.CreditAccountFlowRpcParam;
import com.elitesland.fin.param.flow.AccountFlowRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:账户流水
 * </p>
 *
 * @Author Darren
 * @Date 2023/02/25
 * @Version 1.0
 * @Content:
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + CreditAccountFlowRpcService.PATH)
public interface CreditAccountFlowRpcService {

    String PATH = "/creditAccountFlow";


    /**
     * 账户流水保存
     */
    @PostMapping("/generateCreditAccountFlow")
    ApiResult<String> generateCreditAccountFlow(@RequestBody CreditAccountFlowRpcParam param);

}
