package com.elitesland.fin.service.payorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.param.accountingengine.FinJournalSyncRpcParam;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.payorder.PayOrderRpcParam;
import com.elitesland.fin.param.payorder.PayOrderSyncRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * 付款单
 * @Package com.elitesland.fin.service.payorder
 * @date 2022/5/18 11:43
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + PayOrderRpcService.PATH)
public interface PayOrderRpcService {
    String PATH = "/payOrder";

    @PostMapping("/save")
    Long save(@RequestBody PayOrderRpcParam payOrderRpcParam);

    /**
     * 付款单列表查询
     */
    @PostMapping("/page")
    ApiResult<PagingVO<PayOrderRpcDTO>> page(@RequestBody PayOrderPageRpcParam payOrderPageRpcParam);

    /**
     * 付款单明细信息查询
     */
    @PostMapping("/payOrderDetails")
    ApiResult<List<PayOrderRpcDTO>> payOrderDetails(@RequestBody PayOrderPageRpcParam payOrderPageRpcParam);

    /**
     * 更新状态
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody PayOrderSyncRpcParam param);

}
