package com.elitesland.fin.dto.accountingengine;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.arorder
 * @date 2022/4/12 16:14
 */
@Data
public class FinSetOfBookRpcDTO implements Serializable {

    private static final long serialVersionUID = 3885513784926932000L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("账套编码")
    private String sobCode;

    @ApiModelProperty("账套名称")
    private String sobName;

    @ApiModelProperty("会计期间编码")
    private String accountPeriodCode;

    @ApiModelProperty("会计期间名称")
    private String accountPeriodName;

    @ApiModelProperty("本位币")
    private String currCode;

    @ApiModelProperty("本位币名称")
    private String currName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-fin", mod = "ACTIVE_STATUS")
    private String status;
    private String statusName;

    @ApiModelProperty("账套明细")
    private List<FinSetOfBookLineRpcDTO> dimenDetailList;

    @ApiModelProperty("期间年份")
    private List<String> yearList;
}
