package com.elitesland.fin.dto.aporder;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.application.facade.vo.aporder
 * @date 2022/3/17 13:00
 */

@Data
public class ApOrderDtlRpcDTO implements Serializable {

    private static final long serialVersionUID = -1218468893585681685L;
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "总单ID")
    private Long masId;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;

    @ApiModelProperty(value = "来源行号")
    private Integer sourceLine;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品名称")
    private String itemName;

    @ApiModelProperty(value = "规格型号")
    private String itemType;

    @ApiModelProperty(value = "小类编码")
    private String smallCateCode;

    @ApiModelProperty(value = "小类名称")
    private String smallCateName;

    @ApiModelProperty(value = "计量单位")
    private String uom;

    @ApiModelProperty(value = "计量单位名称")
    private String uomName;

    @ApiModelProperty(value = "数量")
    private BigDecimal qty;

    @ApiModelProperty(value = "单价")
    private BigDecimal exclTaxPrice;

    @ApiModelProperty(value = "含税单价")
    private BigDecimal price;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty(value = "不含税总金额")
    private BigDecimal exclTaxAmt;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmt;

    @ApiModelProperty(value = "含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "不含税总金额(本位币)")
    private BigDecimal exclTaxCurAmt;

    @ApiModelProperty(value = "税额(本位币)")
    private BigDecimal taxCurAmt;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("已核销金额")
    private BigDecimal verAmt;

    @ApiModelProperty("未核销金额")
    private BigDecimal unVerAmt;

    @ApiModelProperty("核销申请中金额")
    private BigDecimal applyVerAmTing;


    @ApiModelProperty("付款协议编码")
    private String protocolCode;

    @ApiModelProperty("付款协议名称")
    private String protocolName;

    @ApiModelProperty("起算日期")
    private LocalDate startCalDate;

    @ApiModelProperty("到期付款日")
    private LocalDate expirePayDate;

    @ApiModelProperty("单位成本")
    private BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;

    @ApiModelProperty("关联单号(对账单号)")
    private String relateDocNo;

    @ApiModelProperty(value = "关联单行号(对账单)")
    private Integer relateDocLine;

    @ApiModelProperty("来源行号ID")
    private Long sourceNoDid;

    @ApiModelProperty("传帐状态(yst-fin/AP_TRANSFER_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_TRANSFER_STATUS")
    private String transferStatus;
    private String transferStatusName;

    @ApiModelProperty("固定资产推送状态(yst-fin/AP_SYNC_STATUS)")
    @SysCode(sys = "yst-fin", mod = "AP_SYNC_STATUS")
    private String syncStatus;
    private String syncStatusName;

    @ApiModelProperty("推送日志")
    private String syncError;

    @ApiModelProperty("财务评估类公司类型")
    private String finAssessmentOuType;
    private String finAssessmentOuTypeName;

    @ApiModelProperty(value = "财务评估类值")
    @SysCode(sys = "yst-supp", mod = "FIN_ASSESSMENT")
    private String finAssessmentValue;
    @ApiModelProperty("财务评估类值")
    private String finAssessmentValueName;

    @ApiModelProperty("采购入库仓库ID")
    private Long purRecvWhId;

    @ApiModelProperty("采购入库仓库编码")
    private String purRecvWhCode;



}
