package com.elitesland.fin.param.payorder;

import com.elitesland.fin.dto.payorder.SyncRecordRpcDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明: 手动拟定参数
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/19
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "payOrderSyncRpcParam",description = "付款单同步司库")
public class PayOrderSyncRpcParam implements Serializable {
    private static final long serialVersionUID = 8112947044089351933L;

    @ApiModelProperty("ID")
    private Long id;
    private List<Long> idList;

    @ApiModelProperty("付款单号")
    private String payOrderNo;

    @ApiModelProperty("制单状态")
    private String syncStatus;

    @ApiModelProperty("支付状态")
    private String payStatus;

    @ApiModelProperty("失败原因")
    private String syncError;

    @ApiModelProperty("外部系统key")
    private String outSysKey;

    @ApiModelProperty("交易流水号")
    private String transNo;

    @ApiModelProperty("受理流水号")
    private String rcvSeqNo;

    @ApiModelProperty("业务关键字")
    private String businessKey;

    @ApiModelProperty("系统财务流水号")
    private String sysAcntgSeqNo;

    @ApiModelProperty("付款单同步记录")
    private SyncRecordRpcDTO syncRecord;

}
