package com.elitesland.fin.service.recorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.dto.recorder.RecOrderRpcDTO;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.recorder.RecOrderRpcPageParam;
import com.elitesland.fin.param.recorder.RecOrderRpcParam;
import com.elitesland.fin.service.arorder.ArOrderRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author wang.xl
 * @version V1.0
 * 收款单
 * @Package com.elitesland.fin.service.recorder
 * @date 2022/5/19 09:50
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + RecOrderRpcService.PATH)
public interface RecOrderRpcService {
    String PATH = "/recOrder";
    @PostMapping("/save")
    Long save(@RequestBody RecOrderRpcParam recOrderRpcParam);

    /**
     * 收款单列表查询
     */
    @PostMapping("/page")
    ApiResult<PagingVO<RecOrderRpcDTO>> page(@RequestBody RecOrderRpcPageParam recOrderRpcPageParam);

}
