package com.elitesland.fin.service.refund;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.paymentruleconfig.PaymentRuleConfigDtlRpcDTO;
import com.elitesland.fin.param.paymentruleconfig.PaymentRuleConfigRpcParam;
import com.elitesland.fin.param.refund.RefundRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author gyj
 * @date 2023/3/7 13:56
 */
@RestController
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + RefundRpcService.PATH)
public interface RefundRpcService {

    String PATH = "rpc/refund";

    /**
     * 退款
     */
    @PostMapping("/refund")
    ApiResult<Void> refund(@RequestBody List<RefundRpcParam> param);
}
