package com.elitesland.fin.dto.invoice;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description 门店费用主表
 * @Date 2023/8/9
 */
@Data
public class PaymentChargesRpcDTO implements Serializable {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("加盟商ID")
    private Long franchiseeId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("收费规则编码")
    private String feeRuleCode;

    @ApiModelProperty("收费规则名称")
    private String feeRuleName;

    @ApiModelProperty("费用金额")
    private BigDecimal totalChargesAmt;

}
