package com.elitesland.fin.dto.inputinv;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


/**
 * @author zhiyu.he
 * @date 2022/5/6 13:12
 */
@Data
public class InputInvRpcDTO implements Serializable {
    private static final long serialVersionUID = 1749011990542443842L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("来源单号")
    private String sourceNo;

    @ApiModelProperty("公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("发票登记单号")
    private String invRegNo;

    @ApiModelProperty("币种编码")
    private String currCode;

    @ApiModelProperty("币种")
    private String currName;

    @ApiModelProperty("本位币编码")
    private String localCurrCode;

    @ApiModelProperty("本位币名称")
    private String localCurrName;

    @ApiModelProperty("含税总金额")
    private BigDecimal totalAmt;

    @ApiModelProperty("含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty("开户行")
    private String openBank;

    @ApiModelProperty("账号")
    private String bankAccount;

    @ApiModelProperty("详细地址")
    private String suppAddress;

    @ApiModelProperty("供应商备注")
    private String suppRemark;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商ID")
    private Long suppId;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商电话")
    private String suppTel;

    @ApiModelProperty("开票人")
    private String invUser;

    @ApiModelProperty("收款人")
    private String recUser;

    @ApiModelProperty("复核人")
    private String revUser;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("审核人ID")
    private Long auditUserId;

    @ApiModelProperty("审核人")
    private String auditUser;

    @ApiModelProperty("审核时间")
    private LocalDateTime auditDate;

    @ApiModelProperty("状态")
//    @SysCode(sys = "COM", mod = "APPLY_STATUS")
    private String orderState;

    @ApiModelProperty("汇率")
    private BigDecimal exchangeRate;

    @ApiModelProperty("审核拒绝理由")
    private String auditRejection;

    @ApiModelProperty("来源单据")
//    @SysCode(sys = "FIN", mod = "PINV_CREATE_MODE")
    private String createMode;

    @ApiModelProperty("纳税人识别号")
    private String taxNumber;

    @ApiModelProperty("创建人名称")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改人名称")
    private String updater;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("进项发票明细集合")
    private List<InputInvDtlRpcDTO> dtlVOList;

}
