package com.elitesland.fin.dto.paymentruleconfig;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author gyj
 * @date 2022/12/28 13:05
 */
@Data
public class PaymentRuleConfigDtlNewRpcDTO implements Serializable {
    private static final long serialVersionUID = -59887501116921877L;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

    @ApiModelProperty(value = "优先级")
    private Integer priorityNo;

    @ApiModelProperty("扣款单据状态")
    private String optDocStatus;

    @ApiModelProperty("扣款单据类型")
    private String optDocType;

    @ApiModelProperty("扣款账户类型")
    private String optAccountType;

    @ApiModelProperty("最高扣款比例")
    private BigDecimal calculatePercent;

//    @ApiModelProperty("扣款单据类型")
//    private String docType;
//
//    @ApiModelProperty("扣款单据状态")
//    private String docStatus;
//
//    @ApiModelProperty("扣款账户类型")
//    private String accountType;

    //rpc

    @ApiModelProperty("账户编码")
    private String accountCode;

    @ApiModelProperty("账户类型")
    private String accountType;
    private String accountTypeName;

    @ApiModelProperty("账户名称")
    private String accountName;

    @ApiModelProperty("可用金额")
    private BigDecimal availableAmount;

    @ApiModelProperty("订单可用金额")
    private BigDecimal orderAvailableAmount;

    @ApiModelProperty("时间")
    private LocalDateTime time;

    @ApiModelProperty("流水号")
    private String flowNo;

    @ApiModelProperty("订单可用支付金额")
    private BigDecimal orderTotalAvailableAmount;

    @ApiModelProperty("可开票金额")
    private BigDecimal invoiceAmount;

    @ApiModelProperty("支付金额")
    private BigDecimal paymentAmount;

    @ApiModelProperty("参与计算标识")
    private boolean calculateFlag;

    @ApiModelProperty("适用单据")
    private String optDoc;

    @ApiModelProperty("是否启用，默认为启用 [UDC]FIN:ACTIVE_STATUS")
    private String status;
}
