package com.elitesland.fin.param.arorder;


import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/11/04
 * @Version 1.0
 * @Content:
 */
@Data
public class ArOrderHandleRpcParam implements Serializable {
    private static final long serialVersionUID = 3712525397318486773L;


    private Long id;

    private String sourceNo;

    private String arOrderNo;

    private String ouCode;

    private Long ouId;

    private String ouName;

    private String createMode;

    private Long arTypeId;

    private String arTypeName;

    private String arTypeCode;

    private String orderState;

    private LocalDateTime buDate;

    private BigDecimal totalAmt;

    private BigDecimal exclTaxAmt;

    private BigDecimal taxAmt;

    private BigDecimal totalCurAmt;

    private BigDecimal exclTaxCurAmt;

    private BigDecimal taxCurAmt;

    private String currCode;

    private String currName;

    private String localCurrCode;

    private String localCurrName;

    private Long auditUserId;

    private String auditUser;

    private LocalDateTime auditDate;

    private BigDecimal exchangeRate;

    private Long operUserId;

    private String operator;

    private Boolean taxFlag;

    private Boolean initFlag;

    private String auditRejection;

    private Long custId;

    private String custCode;

    private String custName;

    private Long buId;

    private String buCode;

    private String buName;

    private String buType;

    private String verState;

    private BigDecimal verAmt;

    private Long orgId;

    private String orgCode;

    private String orgName;

    private Long saleUserId;

    private String saleUser;

    private String arOrderType;

    private String creator;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    private String remark;

    private Integer auditDataVersion;

    private String procInstId;

    //private ProcInstStatus procInstStatus;

    private LocalDateTime submitTime;

    private LocalDateTime approvedTime;

    private List<ArOrderDtlHandleRpcParam> dtlList;

    private String docType;

    private String docType2;

    private String docCls;

    @ApiModelProperty("扩展表关联字段")
    private Long relateId;

    @ApiModelProperty("订单客户")
    private String es1;

    @ApiModelProperty("发票号")
    private String es2;

    @ApiModelProperty("开票日期")
    private LocalDateTime es3;

    @ApiModelProperty("发票类型")
    private String es4;

    @ApiModelProperty("起算日期")
    private LocalDateTime es5;

    @ApiModelProperty("红冲标志")
    private String es6;


//    @ApiModelProperty("开票备注")
//    private String es7;
//
//    @ApiModelProperty("第三方支付辅助")
//    private String es8;
//
//    @ApiModelProperty("消费卡辅助")
//    private String es9;
//
//    @ApiModelProperty("信用卡辅助")
//    private String es10;

    @ApiModelProperty("结算方式")
    private String settlementType;
    @ApiModelProperty("拟定状态")
    private String proposedStatus;

    @ApiModelProperty("红冲状态")
    private Boolean redState;

    @ApiModelProperty("红冲来源")
    private String redSourceNo;

    @ApiModelProperty("红冲来源")
    private Long redSourceId;

    @ApiModelProperty("是否检验")
    private Boolean check = Boolean.TRUE;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("扩展信息")
    private Map<String, String> extensionInfo;

    @ApiModelProperty(value = "内外部客户")
    private String inOutCust;

    @ApiModelProperty("收款协议编码")
    private String protocolCode;

    @ApiModelProperty("关联公司编码")
    private String relevanceOuCode;


}
