package com.elitesland.fin.dto.payorder;

import com.elitescloud.cloudt.sys.component.med.BaseModelMedOrderDVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author zhiyu.he
 * @date 2022/3/16 10:36
 */
@Data
public class PayOrderDtlRpcDTO extends BaseModelMedOrderDVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -9126525154153716180L;

    @ApiModelProperty(value = "付款方式")
    private String payType;
    @ApiModelProperty(value = "付款方开户银行")
    private String payBank;
    @ApiModelProperty(value = "付款方银行账户")
    private String payAccount;
    @ApiModelProperty(value = "收款方开户银行")
    private String recBank;
    @ApiModelProperty(value = "收款方银行账户")
    private String recAccount;

    @ApiModelProperty(value = "来源单号")
    private String sourceNo;
    @ApiModelProperty(value = "来源行号")
    private Integer sourceLine;
    @ApiModelProperty(value = "来源单号ID")
    private Long sourceId;
    @ApiModelProperty(value = "来源行号ID")
    private Long sourceLineId;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty(value = "单位", notes = "[UDC]yst-supp:UOM")
    private String uom;
    @ApiModelProperty(value = "基本单位", notes = "[UDC]yst-supp:UOM")
    private String uom2;

    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("汇率")
    private BigDecimal currRate;

    @ApiModelProperty("税率编号")
    private String taxRateNo;
    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("本币含税单价(调整后)")
    private BigDecimal currPrice;
    @ApiModelProperty("本币不含税单价(调整后)")
    private BigDecimal currNetPrice;
    @ApiModelProperty("含税单价(调整后)")
    private BigDecimal price;
    @ApiModelProperty("不含税价格(调整后)")
    private BigDecimal netPrice;

    @ApiModelProperty("含税金额(调整后)")
    private BigDecimal amt;
    @ApiModelProperty("不含税金额(调整后)")
    private BigDecimal netAmt;
    @ApiModelProperty("本币含税金额(调整后)")
    private BigDecimal currAmt;
    @ApiModelProperty("本币不含税金额(调整后)")
    private BigDecimal currNetAmt;

    @ApiModelProperty("税额(调整后)")
    private BigDecimal taxAmt;

    @ApiModelProperty("关联单据类别 [UDC]SUPP:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("单据日期")
    private LocalDateTime relateDocDate;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLine;

    @ApiModelProperty("关联单据2类别 [UDC]yst-supp:DOC_CLS")
    private String relateDoc2Cls;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据明细2ID")
    private Long relateDoc2Did;
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Line;

    @ApiModelProperty(value = "本次申请含税总金额")
    private BigDecimal totalAmt;
    @ApiModelProperty(value = "本次申请含税总金额(本位币)")
    private BigDecimal totalCurAmt;

    @ApiModelProperty(value = "费用类型", notes = "[UDC]yst-fin:EXPENSES_TYPE")
    private String expensesType;

    @ApiModelProperty(value = "费用部门ID")
    private Long buId;
    @ApiModelProperty(value = "费用部门编码")
    private String buCode;
    @ApiModelProperty(value = "费用部门")
    private String buName;

    @ApiModelProperty("备注")
    private String remark;
}
