package com.elitesland.fin.service.payorder;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.fin.Application;
import com.elitesland.fin.dto.payorder.PayOrderRpcDTO;
import com.elitesland.fin.param.payorder.PayOrderPageRpcParam;
import com.elitesland.fin.param.payorder.PayOrderRpcParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author wang.xl
 * @version V1.0
 * 付款单
 * @Package com.elitesland.fin.service.payorder
 * @date 2022/5/18 11:43
 */
@Validated
@FeignClient(name = Application.NAME,path = Application.PATH + PayOrderRpcService.PATH)
public interface PayOrderRpcService {
    String PATH = "/payOrder";

    @PostMapping("/save")
    Long save(@RequestBody PayOrderRpcParam payOrderRpcParam);

    @PostMapping("/saveParOrder")
    PayOrderRpcDTO saveParOrder(@RequestBody PayOrderRpcParam payOrderRpcParam);

    @ApiOperation(value = "批量创建付款单")
    @PostMapping("/saveBatch")
    ApiResult<Map<String, PayOrderRpcDTO>> saveBatch(@RequestBody List<PayOrderRpcParam> paramList);

    /**
     * 付款单列表查询
     */
    @PostMapping("/page")
    ApiResult<PagingVO<PayOrderRpcDTO>> page(@RequestBody PayOrderPageRpcParam payOrderPageRpcParam);

}
