package com.elitesland.fin.dto.paymentruleconfig;

import com.el.coordinator.core.common.jpa.vo.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Auther: Mark
 * @Date: 2024/7/17 19:40
 * @Description:
 */
@Data
public class PaymentRuleConfigDtlDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 4672617184239248923L;

    @ApiModelProperty(value = "主表ID")
    private Long masId;

//    @ApiModelProperty(value = "事务码")
//    private String ioCode;
//
//    @ApiModelProperty("事务码名称")
//    private String ioName;

    @ApiModelProperty("适用单据类型")
    private String optDocType;

    @ApiModelProperty("适用单据类型名称")
    private String optDocTypeName;

    @ApiModelProperty("适用单据状态")
    @SysCode(sys = "yst-supp", mod = "DOC_STATUS")
    private String optDocStatus;
    private String optDocStatusName;

    @ApiModelProperty("扣款账户类型")
    private String optAccountType;
    private String optAccountTypeName;

    @ApiModelProperty("指定账户")
    private String specificAccount;

    @ApiModelProperty("指定账户名称")
    private String specificAccountName;

    @ApiModelProperty("最高透支额度")
    private BigDecimal maxLimit;

    @ApiModelProperty(value = "优先级")
    private Integer priorityNo;

    @ApiModelProperty("最高扣款比例")
    private BigDecimal calculatePercent;

    @ApiModelProperty(value = "流水自动审核 1-是 0-否")
    private boolean automaticReview;
}
