package com.elitesland.fin.param.creditaccount;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.fin.param.account
 * @date 2023/3/7 13:59
 */
@Data
public class CreditAccountRpcParam {

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("对象类型(客户组 客户)")
    private String objectType;

    @ApiModelProperty("对象名称(客户组名称/客户名称)")
    private String objectName;

    @ApiModelProperty("信用账户编码")
    private String creditAccountCode;

    @ApiModelProperty("信用账户名称")
    private String creditAccountName;

    @ApiModelProperty("信用账户类型")
    private String creditAccountType;

    @ApiModelProperty("对象编码")
    private String objectCode;

    @ApiModelProperty("部门ID")
    private Long deptId;

    @ApiModelProperty("部门编码")
    private String deptCode;

    @ApiModelProperty("部门名称")
    private String deptName;

    @ApiModelProperty("产品线编码")
    private String productLineCode;

    @ApiModelProperty("产品线名称")
    private String productLineName;

    @ApiModelProperty("业务员编号")
    private String salesmanNo;

    @ApiModelProperty("业务员姓名")
    private String salesmanName;

    @ApiModelProperty("信用账户额度")
    private BigDecimal creditAccountLimit;

    @ApiModelProperty("信用账户占用额度")
    private BigDecimal creditAccountOccupancyLimit;

    @ApiModelProperty("信用账户使用额度")
    private BigDecimal creditAccountUsedLimit;

    @ApiModelProperty("是否启用")
    private String status;

    @ApiModelProperty("备注")
    private String remark;

}
