package com.elitesland.scp.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Auther: Mark
 * @Date: 2024/5/6 11:43
 * @Description:
 */
public class DayOfWeekEnumHelper {
    public static List<String> splitAndList(String detailedTimeStr) {
        List<String> result = new ArrayList<>();
        String[] split = detailedTimeStr.split(",");
        for (String codeName : split) {
            result.add(DayOfWeekEnum.getCode(codeName));
        }
        return result;
    }

    public static String splitAndListDesc(String detailedTimeStr) {
        List<String> builder = new ArrayList<>();
        String[] split = detailedTimeStr.split(",");
        for (String codeName : split) {
            builder.add(DayOfWeekEnum.getDesc(codeName));
        }
        return String.join(",", builder);
    }

    public static String splitAndListCodeName(String detailedTimeStr) {
        List<String> builder = new ArrayList<>();
        String[] split = detailedTimeStr.split(",");
        for (String desc : split) {
            builder.add(DayOfWeekEnum.getCodeName(desc));
        }
        return String.join(",", builder);
    }

    public static boolean validDesc(String detailedTimeStr) {
        String[] split = detailedTimeStr.split(",");
        if (split.length == 0) {
            return false;
        }
        List<String> descList = Arrays.stream(DayOfWeekEnum.values())
                .map(DayOfWeekEnum::getDesc)
                .collect(Collectors.toList());

        for (String str : split) {
            if (!descList.contains(str)) {
                return false;
            }
        }
        return true;
    }
}
