package com.elitesland.scp.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;


/**
 * @author jeesie
 * @description:
 * @datetime 2024年 03月 22日 11:33
 * @version: 1.0
 */
@Data
@ApiModel( description = "仓库关系查询rpc 参数")
public class ScpWhNetRelationRpcDtoParam implements Serializable {

    @ApiModelProperty(value = "类型")
    @NotBlank(message = "类型不能为空")
    private String type;

    @ApiModelProperty(value = "需求仓库编码/门店编码")
    @NotEmpty(message = "需求仓库编码/门店编码不能为空")
    private String demandWhStCode;

    @ApiModelProperty(value = "商品品类")
    private String itemCateCode;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "商品编码集合")
    private List<String> itemCodes;

    @ApiModelProperty(value = "公司集合")
    private List<String> ouCodes;

//    @ApiModelProperty(value = "有效日期")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    private LocalDateTime validDate;







}
