package com.elitesland.scp.service.authority;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.scp.ScpApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

@FeignClient(name = ScpApplication.NAME, path = ScpApplication.PATH + InvWhAuthorityRpcService.PATH)
@Validated
public interface InvWhAuthorityRpcService {

    String PATH = "/authority/invwh";

    /**
     * 获取当前登录账号对应的计划员权限所属仓库
     *
     * @param
     * @return
     */
    @PostMapping("/getAuthorityData")
    ApiResult<List<String>> getAuthorityData();

    /**
     * 获取当前登录账号对应的计划员权限所属门店
     *
     * @param
     * @return
     */
    @PostMapping("/findStoreAuthorityData")
    ApiResult<List<String>> findStoreAuthorityData();


    /**
     * 获取当前登录账号对应的计划员权限所属仓库id集合
     *
     * @param
     * @return
     */
    @PostMapping("/getAuthorityDataIds")
    ApiResult<List<Long>> getAuthorityDataIds();

}
