package com.elitesland.yst.seata.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Data
@ApiModel("Http接口-保存接口参数数据")
public class HttpParamPayload {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("Http接口")
    private Long httpId;

    @ApiModelProperty("输入输出类型")
    private String reqRespType;
    @ApiModelProperty("请求类型")
    private String requestType;

    @ApiModelProperty("参数名称")
    @NotBlank
    private String paramName;
    @ApiModelProperty("参数类型")
    private String paramType;
    @ApiModelProperty("参数描述")
    private String paramDesc;
    @ApiModelProperty("参数值")
    private String paramValue;
    @ApiModelProperty("参数父类")
    private Long parentId;
    @ApiModelProperty("参数排序号")
    private Integer orderNo;
    @ApiModelProperty("分库字段")
    private Integer dbId;
    @ApiModelProperty("分表字段")
    private Integer tableId;

    @ApiModelProperty("参数子列表")
    private List<HttpParamPayload> subParamList;
}
