package com.elitesland.yst.security.config;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.yst.supportdomain.provider.org.service.OrgUserEmpBuRpcService;
import com.elitesland.yst.system.service.SysUserService;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.util.ObjectUtils;

import java.util.Objects;

/**
 * @author Michael Li
 * @date AC 2021-04-12:23:49
 */
@Slf4j
@Configuration
public class UserDetailsConfig {

    private static final String ROLE_VOTER_PREFIX = "ROLE_";

    @Bean
    public UserDetailsManager userDetailsManager() {
        return new UserDetailsManager() {

            @DubboReference(version = "${provider.service.version}", check = false, timeout = 10000)
            private SysUserService sysUserService;

//            @DubboReference(version = "${provider.service.version}", check = false, timeout = 10000)
//            private SysButableService sysButableService;
            //dubbo本地伪装，用于处理找不到支撑域服务，而报错，影响登录
//            @DubboReference(mock = "return null")
//            private OrgBuRpcService orgBuRpcService;

            //dubbo本地伪装，用于处理找不到支撑域服务，而报错，影响登录
//            @DubboReference(mock = "return null")
//            @DubboReference( check = false, timeout = 10000)
//            private OrgUserDetailRpcService orgUserDetailRpcService;

            @DubboReference(timeout = 10000, check = false)
            private OrgUserEmpBuRpcService orgUserEmpBuRpcService;
            
            
            @Override
            public void createUser(UserDetails user) {

            }

            @Override
            public void updateUser(UserDetails user) {

            }

            @Override
            public void deleteUser(String username) {

            }

            @Override
            public void changePassword(String oldPassword, String newPassword) {

            }

            @Override
            public boolean userExists(String username) {
                return false;
            }

            @Override
            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DisabledException {
                val user = sysUserService.getUserByUsername(username);
                if (user == null) {
                    throw new UsernameNotFoundException("账号或密码错误");
                }
                /***获取用户的员工，员工组织，员工下级，员工组织下级 todo 支撑域接口 ***/
                var orgUserEmpBuDTOApiResult
                        = orgUserEmpBuRpcService.findUserEmpBuInfoByUserId(user.getId());
                try {
                    if (!Objects.isNull(user.getEnabled()) && !user.getEnabled()) {
                        throw new DisabledException("账号已被禁用");
                    }
//                //更新buTable
//                TableContext.remove();
//                //重新设置buTable
//                TableContext.setTables(sysButableService.listButable());

                    // 通过支撑域获取指定用户所拥有的组织 ID 列表
                    // 支撑域绑定关系：用户ID -> 员工ID -> 组织ID和组织树ID -> 树形结构获取所当前组织下所有的组织ID，包含当前组织ID的列表 -> 返回数据
                    // 2021取消掉 数据在下面orgBuRpcSaveOrUpdate接口封装提供
//                List<Long> buIds = orgBuRpcService.findBuIdsByUserId(user.getId());
                    //如果是null 意味着没有获取到数据权限。异常，失败等情况，需要使用的是否判断
                    SecurityOrgUserEmpBuDTO securityOrgUserEmpBuDTO = null;
                    if (orgUserEmpBuDTOApiResult != null) {
                        if (orgUserEmpBuDTOApiResult.isSuccess()) {
                            if (orgUserEmpBuDTOApiResult.getData() == null) {
                                //这种情况查询成功了 返回null 规则上是不应该发生的。 如果成功就应该返回对象。避免真的接口放传递null，
                                // 初始化下。视作执行成功了，没有找到相关信息
                                securityOrgUserEmpBuDTO = new SecurityOrgUserEmpBuDTO();
                                securityOrgUserEmpBuDTO.setUserId(user.getId());
                            } else {
                                OrgUserEmpBuDTO orgUserEmpBuDTO   =orgUserEmpBuDTOApiResult.getData();
                                securityOrgUserEmpBuDTO = new SecurityOrgUserEmpBuDTO();
                                securityOrgUserEmpBuDTO.setUserId(orgUserEmpBuDTO.getUserId());
                                securityOrgUserEmpBuDTO.setEmpId(orgUserEmpBuDTO.getEmpId());
                                securityOrgUserEmpBuDTO.setEmpCodePath(orgUserEmpBuDTO.getEmpCodePath());
                                securityOrgUserEmpBuDTO.setChildEmpIds(orgUserEmpBuDTO.getChildEmpIds());
                                securityOrgUserEmpBuDTO.setEmpBuTreeId(orgUserEmpBuDTO.getEmpBuTreeId());
                                securityOrgUserEmpBuDTO.setEmpBuIds(orgUserEmpBuDTO.getEmpBuIds());
                                securityOrgUserEmpBuDTO.setEmpBuCodePath(orgUserEmpBuDTO.getEmpBuCodePath());
                                securityOrgUserEmpBuDTO.setChildEmpBuIds(orgUserEmpBuDTO.getChildEmpBuIds());
                                //员工所属总公司编码
//                                securityOrgUserEmpBuDTO.setTopBuCode(orgUserEmpBuDTO.getHeadOuCode());
                            }
                        } else {
                            throw new UsernameNotFoundException("支撑域微服务失败：" + Objects.requireNonNullElse(orgUserEmpBuDTOApiResult.getMsg(), "null"));
                        }
                    }else {
                        throw new UsernameNotFoundException("支撑域微服务调用失败,请检查服务状态" );
                    }
//                TableContext.removeBuidByUserid(user.getId().toString());
//                TableContext.setBuIdMap(user.getId().toString(), buIds);

                    user.getRoles().forEach(r -> {
                        r.setCode(ROLE_VOTER_PREFIX + r.getCode());
                    });

                    //TODO: 需要增加从支撑域获取用户的被授权的离散BU IDs列表的赋值  20210714取消掉.setSelfBuIds(buIds)
                    return new GeneralUserDetails(user)
                            .setSecurityOrgUserEmpBuDTO(securityOrgUserEmpBuDTO);
                } catch (Exception e) {
                    throw new UsernameNotFoundException("账号认证异常：" + e.getMessage());
                }
            }
        };
    }
}
