/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.security.config;

import com.elitesland.yst.common.base.ApiResult;
import com.elitesland.yst.common.exception.BusinessException;
import com.elitesland.yst.security.config.CustomUserDetailsChecker;
import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.security.entity.GeneralUserDetails;
import com.elitesland.yst.supportdomain.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.yst.supportdomain.provider.org.service.OrgUserEmpBuRpcService;
import com.elitesland.yst.system.service.SysUserService;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.provisioning.UserDetailsManager;

@Configuration
public class UserDetailsConfig {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsConfig.class);
    private static final String ROLE_VOTER_PREFIX = "ROLE_";
    private final List<CustomUserDetailsChecker> userDetailCheckers;

    public UserDetailsConfig(ObjectProvider<CustomUserDetailsChecker> userDetailCheckerProvider) {
        this.userDetailCheckers = userDetailCheckerProvider.stream().collect(Collectors.toList());
    }

    @Bean
    public UserDetailsManager userDetailsManager() {
        return new UserDetailsManager(){
            @DubboReference(version="${provider.service.version}", check=false, timeout=10000)
            private SysUserService sysUserService;
            @DubboReference(timeout=10000, retries=-1, check=false)
            private OrgUserEmpBuRpcService orgUserEmpBuRpcService;

            public void createUser(UserDetails user) {
            }

            public void updateUser(UserDetails user) {
            }

            public void deleteUser(String username) {
            }

            public void changePassword(String oldPassword, String newPassword) {
            }

            public boolean userExists(String username) {
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DisabledException {
                SysUserDTO user = this.sysUserService.getUserByUsername(username);
                if (user == null) {
                    throw new UsernameNotFoundException("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
                }
                ApiResult orgUserEmpBuDTOApiResult = this.orgUserEmpBuRpcService.findUserEmpBuInfoByUserId(user.getId());
                try {
                    if (!Objects.isNull(user.getEnabled()) && !user.getEnabled().booleanValue()) {
                        throw new DisabledException("\u8d26\u53f7\u5df2\u88ab\u7981\u7528");
                    }
                    SecurityOrgUserEmpBuDTO securityOrgUserEmpBuDTO = null;
                    if (orgUserEmpBuDTOApiResult == null) throw new UsernameNotFoundException("\u652f\u6491\u57df\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25,\u8bf7\u68c0\u67e5\u670d\u52a1\u72b6\u6001");
                    if (!orgUserEmpBuDTOApiResult.isSuccess()) throw new UsernameNotFoundException("\u652f\u6491\u57df\u5fae\u670d\u52a1\u5931\u8d25\uff1a" + Objects.requireNonNullElse(orgUserEmpBuDTOApiResult.getMsg(), "null"));
                    if (orgUserEmpBuDTOApiResult.getData() == null) {
                        securityOrgUserEmpBuDTO = new SecurityOrgUserEmpBuDTO();
                        securityOrgUserEmpBuDTO.setUserId(user.getId());
                    } else {
                        OrgUserEmpBuDTO orgUserEmpBuDTO = (OrgUserEmpBuDTO)orgUserEmpBuDTOApiResult.getData();
                        securityOrgUserEmpBuDTO = new SecurityOrgUserEmpBuDTO();
                        securityOrgUserEmpBuDTO.setUserId(orgUserEmpBuDTO.getUserId());
                        securityOrgUserEmpBuDTO.setEmpId(orgUserEmpBuDTO.getEmpId());
                        securityOrgUserEmpBuDTO.setEmpCodePath(orgUserEmpBuDTO.getEmpCodePath());
                        securityOrgUserEmpBuDTO.setChildEmpIds(orgUserEmpBuDTO.getChildEmpIds());
                        securityOrgUserEmpBuDTO.setEmpBuTreeId(orgUserEmpBuDTO.getEmpBuTreeId());
                        securityOrgUserEmpBuDTO.setEmpBuIds(orgUserEmpBuDTO.getEmpBuIds());
                        securityOrgUserEmpBuDTO.setEmpBuCodePath(orgUserEmpBuDTO.getEmpBuCodePath());
                        securityOrgUserEmpBuDTO.setChildEmpBuIds(orgUserEmpBuDTO.getChildEmpBuIds());
                    }
                    user.getRoles().forEach(r -> r.setCode(UserDetailsConfig.ROLE_VOTER_PREFIX + r.getCode()));
                    GeneralUserDetails userDetails = new GeneralUserDetails(user).setSecurityOrgUserEmpBuDTO(securityOrgUserEmpBuDTO);
                    UserDetailsConfig.this.checkUserDetails(userDetails);
                    return userDetails;
                }
                catch (Exception e) {
                    if (e instanceof UsernameNotFoundException) {
                        throw e;
                    }
                    if (!(e instanceof BusinessException)) throw new UsernameNotFoundException("\u8d26\u53f7\u8ba4\u8bc1\u5f02\u5e38\uff1a" + e.getMessage());
                    throw new UsernameNotFoundException(e.getMessage());
                }
            }
        };
    }

    private void checkUserDetails(GeneralUserDetails userDetails) {
        if (this.userDetailCheckers.isEmpty()) {
            return;
        }
        for (CustomUserDetailsChecker userDetailChecker : this.userDetailCheckers) {
            userDetailChecker.check(userDetails);
        }
    }
}

