/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.security.entity;

import com.elitesland.yst.security.dto.SecurityOrgUserEmpBuDTO;
import com.elitesland.yst.system.vo.SysRoleVO;
import com.elitesland.yst.system.vo.SysUserDTO;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class GeneralUserDetails
implements UserDetails {
    private static final long serialVersionUID = 414652772107486653L;
    private SysUserDTO user;
    private String ip;
    private String browser;
    private String address;
    private LocalDateTime loginExpiredAt;
    private String token;
    private List<Long> selfBuIds;
    private SecurityOrgUserEmpBuDTO securityOrgUserEmpBuDTO;
    private List<Long> grantedBuIds;

    public GeneralUserDetails(SysUserDTO sysUserDTO) {
        this.user = sysUserDTO;
    }

    public List<String> getRoleCodes() {
        if (this.user.getRoles() == null) {
            return null;
        }
        return this.user.getRoles().stream().map(SysRoleVO::getCode).collect(Collectors.toList());
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.user.getRoles() == null) {
            return null;
        }
        return this.user.getRoles().stream().map(SysRoleVO::getCode).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public boolean isAccountNonLocked() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public boolean isCredentialsNonExpired() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public boolean isEnabled() {
        return !Objects.isNull(this.user.getEnabled()) && this.user.getEnabled() != false;
    }

    public SysUserDTO getUser() {
        return this.user;
    }

    public String getIp() {
        return this.ip;
    }

    public String getBrowser() {
        return this.browser;
    }

    public String getAddress() {
        return this.address;
    }

    public LocalDateTime getLoginExpiredAt() {
        return this.loginExpiredAt;
    }

    public String getToken() {
        return this.token;
    }

    public List<Long> getSelfBuIds() {
        return this.selfBuIds;
    }

    public SecurityOrgUserEmpBuDTO getSecurityOrgUserEmpBuDTO() {
        return this.securityOrgUserEmpBuDTO;
    }

    public List<Long> getGrantedBuIds() {
        return this.grantedBuIds;
    }

    public GeneralUserDetails setUser(SysUserDTO user) {
        this.user = user;
        return this;
    }

    public GeneralUserDetails setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public GeneralUserDetails setBrowser(String browser) {
        this.browser = browser;
        return this;
    }

    public GeneralUserDetails setAddress(String address) {
        this.address = address;
        return this;
    }

    public GeneralUserDetails setLoginExpiredAt(LocalDateTime loginExpiredAt) {
        this.loginExpiredAt = loginExpiredAt;
        return this;
    }

    public GeneralUserDetails setToken(String token) {
        this.token = token;
        return this;
    }

    public GeneralUserDetails setSelfBuIds(List<Long> selfBuIds) {
        this.selfBuIds = selfBuIds;
        return this;
    }

    public GeneralUserDetails setSecurityOrgUserEmpBuDTO(SecurityOrgUserEmpBuDTO securityOrgUserEmpBuDTO) {
        this.securityOrgUserEmpBuDTO = securityOrgUserEmpBuDTO;
        return this;
    }

    public GeneralUserDetails setGrantedBuIds(List<Long> grantedBuIds) {
        this.grantedBuIds = grantedBuIds;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralUserDetails)) {
            return false;
        }
        GeneralUserDetails other = (GeneralUserDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SysUserDTO this$user = this.getUser();
        SysUserDTO other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$browser = this.getBrowser();
        String other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !this$browser.equals(other$browser)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        LocalDateTime this$loginExpiredAt = this.getLoginExpiredAt();
        LocalDateTime other$loginExpiredAt = other.getLoginExpiredAt();
        if (this$loginExpiredAt == null ? other$loginExpiredAt != null : !((Object)this$loginExpiredAt).equals(other$loginExpiredAt)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        List<Long> this$selfBuIds = this.getSelfBuIds();
        List<Long> other$selfBuIds = other.getSelfBuIds();
        if (this$selfBuIds == null ? other$selfBuIds != null : !((Object)this$selfBuIds).equals(other$selfBuIds)) {
            return false;
        }
        SecurityOrgUserEmpBuDTO this$securityOrgUserEmpBuDTO = this.getSecurityOrgUserEmpBuDTO();
        SecurityOrgUserEmpBuDTO other$securityOrgUserEmpBuDTO = other.getSecurityOrgUserEmpBuDTO();
        if (this$securityOrgUserEmpBuDTO == null ? other$securityOrgUserEmpBuDTO != null : !((Object)this$securityOrgUserEmpBuDTO).equals(other$securityOrgUserEmpBuDTO)) {
            return false;
        }
        List<Long> this$grantedBuIds = this.getGrantedBuIds();
        List<Long> other$grantedBuIds = other.getGrantedBuIds();
        return !(this$grantedBuIds == null ? other$grantedBuIds != null : !((Object)this$grantedBuIds).equals(other$grantedBuIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralUserDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SysUserDTO $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : $browser.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        LocalDateTime $loginExpiredAt = this.getLoginExpiredAt();
        result = result * 59 + ($loginExpiredAt == null ? 43 : ((Object)$loginExpiredAt).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        List<Long> $selfBuIds = this.getSelfBuIds();
        result = result * 59 + ($selfBuIds == null ? 43 : ((Object)$selfBuIds).hashCode());
        SecurityOrgUserEmpBuDTO $securityOrgUserEmpBuDTO = this.getSecurityOrgUserEmpBuDTO();
        result = result * 59 + ($securityOrgUserEmpBuDTO == null ? 43 : ((Object)$securityOrgUserEmpBuDTO).hashCode());
        List<Long> $grantedBuIds = this.getGrantedBuIds();
        result = result * 59 + ($grantedBuIds == null ? 43 : ((Object)$grantedBuIds).hashCode());
        return result;
    }

    public String toString() {
        return "GeneralUserDetails(user=" + this.getUser() + ", ip=" + this.getIp() + ", browser=" + this.getBrowser() + ", address=" + this.getAddress() + ", loginExpiredAt=" + this.getLoginExpiredAt() + ", token=" + this.getToken() + ", selfBuIds=" + this.getSelfBuIds() + ", securityOrgUserEmpBuDTO=" + this.getSecurityOrgUserEmpBuDTO() + ", grantedBuIds=" + this.getGrantedBuIds() + ")";
    }
}

