package com.elitesland.yst.emdg.sale.rpc;

import com.elitesland.yst.emdg.sale.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/03/14
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.HH_NAME, path = EmdgSaleDealerAuthRangeRpcService.URI)
public interface EmdgSaleDealerAuthRangeRpcService {

    String URI = Application.URI_PREFIX + "/saleDealerAuthRange";

    /**
     * 根据营销经理编码(员工编码)查询经销商编码
     *
     * @param mktManagerCodeList 营销经理编码(员工编码)
     * @return 经销商编码
     */
    @PostMapping("/selectDealerCodeByEmployeeCode")
    List<String> selectDealerCodeByEmployeeCode(@RequestBody List<String> mktManagerCodeList);

    /**
     * 根据营销经理ID(员工ID)查询经销商编码
     *
     * @param mktManagerIdList 营销经理ID(员工ID)
     * @return 经销商编码
     */
    @PostMapping("/selectDealerCodeByEmployeeId")
    List<String> selectDealerCodeByEmployeeId(@RequestBody Set<Long> mktManagerIdList);

}
