package com.tll.housekeeper.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 消息中心记录用户关联表.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "消息中心记录用户关联表")
public class MessageCenterUserRpcDTO implements Serializable {
    
    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty("子任务id")
    private String subtaskId;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("消息中心唯一标识")
    private String messageUnique;

    @ApiModelProperty("状态: 0：未关闭 1：已关闭")
    private Integer status;
    
}
