package com.tll.housekeeper.rpc.param.resp.enums;

import lombok.Getter;

/**
 * 审核状态枚举
 *
 * @author Jxinx
 * @date 2024-09-19
 */
@Getter
public enum AuditStatusEnum {
    PENDING(0, "待审核"),
    PASSED(1, "通过"),
    REJECTED(2, "驳回");

    private final Integer code;
    private final String description;

    AuditStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 根据code获取枚举项
     */
    public static AuditStatusEnum getByCode(Integer code) {
        for (AuditStatusEnum status : AuditStatusEnum.values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    // 通过 description 获取枚举实例
    public static AuditStatusEnum fromDescription(String description) {
        for (AuditStatusEnum status : AuditStatusEnum.values()) {
            if (status.getDescription().equals(description)) {
                return status;
            }
        }
        throw new IllegalArgumentException("没有匹配的审核状态: " + description);
    }
}