package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.plan.InspectPlanAddDTO;
import com.tll.inspect.rpc.dto.plan.InspectPlanDeleteDTO;
import com.tll.inspect.rpc.dto.plan.InspectPlanDetailDTO;
import com.tll.inspect.rpc.dto.plan.InspectPlanDetailLogDTO;
import com.tll.inspect.rpc.dto.plan.InspectPlanEditDTO;
import com.tll.inspect.rpc.dto.plan.InspectPlanPageDTO;
import com.tll.inspect.rpc.vo.plan.ExecutorsPageVO;
import com.tll.inspect.rpc.vo.plan.InspectPlanDetailLogVO;
import com.tll.inspect.rpc.vo.plan.InspectPlanDetailVO;
import com.tll.inspect.rpc.vo.plan.InspectPlanPageVO;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author XieBeiChen
 * @date 2025-06-05 11:23
 * @description
 */
@FeignClient(name = Application.NAME, path = CrossInspectPlanRpcService.URI)
@Validated
public interface CrossInspectPlanRpcService {

    String URI = Application.URI_PREFIX + "/crossInspectPlan";

    @ApiOperation("新增执行计划")
    @PostMapping("/add")
    ApiResult<Void> add(@Valid @RequestBody InspectPlanAddDTO dto);

    @ApiOperation("编辑执行计划")
    @PostMapping("/edit")
    ApiResult<PagingVO<ExecutorsPageVO>> edit(@Valid @RequestBody InspectPlanEditDTO dto);

    @ApiOperation("执行计划列表")
    @PostMapping("/page")
    ApiResult<PagingVO<InspectPlanPageVO>> page(@RequestBody InspectPlanPageDTO dto);


    @ApiOperation("执行计划详情")
    @PostMapping("/detail")
    ApiResult<InspectPlanDetailVO> detail(@Valid @RequestBody InspectPlanDetailDTO dto);


    @PostMapping("/detail/log")
    @ApiOperation("执行计划详情里面的指派记录")
    ApiResult<PagingVO<InspectPlanDetailLogVO>> detailLog(@Valid @RequestBody InspectPlanDetailLogDTO dto);

    @PostMapping("/delete")
    @ApiOperation("删除执行计划")
    ApiResult<Void> delete(@Valid @RequestBody InspectPlanDeleteDTO dto);

}
