package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.signin.SignInAddDTO;
import com.tll.inspect.rpc.dto.signin.SignInAppPageDTO;
import com.tll.inspect.rpc.vo.signin.SignInAppPageVO;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author XieBeiChen
 * @date 2025-06-05 11:23
 * @description
 */
@FeignClient(name = Application.NAME, path = SignInRpcService.URI)
public interface SignInRpcService {

    String URI = Application.URI_PREFIX + "/signIn";
    /**
     * 签到记录添加(每日签到)
     * @param dto
     * @return
     */
    @PostMapping("/add")
    ApiResult<Void> add(@Valid @RequestBody SignInAddDTO dto);


    @PostMapping("/pageForApp")
    @ApiOperation("签到记录")
    ApiResult<PagingVO<SignInAppPageVO>> pageForApp(@RequestBody SignInAppPageDTO dto);


}
