package com.tll.inspect.rpc.dto;

import com.tll.inspect.rpc.dto.media.MediaDTO;
import com.tll.inspect.rpc.vo.signin.SignInListVO.Media;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author XieBeiChen
 * @date 2025-06-12 13:44
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportSaveDraftDTO implements Serializable {

    @ApiModelProperty(value = "报告id",required = true)
    @NotNull(message = "报告id不能为空")
    private Long reportId;

    @ApiModelProperty("报告项")
    private List<Items> items;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Items  implements Serializable {

        @NotNull(message = "巡检项id不能为空")
        @ApiModelProperty(value = "巡检项id",required = true)
        private String itemId;

        @ApiModelProperty(value = "是否合格（1-合格，0-不合格）", required = true)
        @NotNull(message = "是否合格不能为空")
        private Boolean passFlag;

        @ApiModelProperty("原因")
        private String reason;

        @ApiModelProperty(("巡检现场照片或者视频，可选"))
        private List<MediaDTO> fileUrls;
    }

}
