package com.tll.inspect.rpc.dto.signin;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 14:43
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInAddDTO {

    @ApiModelProperty(value = "定位地址，例如“北京市海淀区xxx”",required = true)
    @NotBlank(message = "定位地址不能为空")
    private String location;

    @NotNull(message = "经度不能为空")
    @ApiModelProperty(value = "经度",required = true)
    private Double longitude;

    @NotNull(message = "纬度不能为空")
    @ApiModelProperty(value = "纬度",required = true)
    private Double latitude;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "巡检现场照片或者视频，可选")
    private List<Media> fileUrls;

    @ApiModelProperty("设备码")
    private String deviceCode;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Media {
        @ApiModelProperty("文件类型:0-图片,1-视频")
        private Integer fileType;

        @ApiModelProperty("链接")
        private String url;
    }

    @ApiModelProperty("申诉原因")
    private String appealReason;

    @ApiModelProperty("申诉附件列表")
    private String appealFiles;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("打卡数据来源:1-打卡，2-到店签到，3-离店签退")
    private Integer source;
}
