package com.tll.inspect.rpc.dto.travel;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 行程列表查询参数
 * @author zhaoshuai
 * @date 2025/6/12
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class TravelListQueryRpcDTO extends AbstractExportQueryParam {


    private static final long serialVersionUID = 3798431621169764403L;

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("查询开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("查询结束时间")
    private LocalDateTime endTime;

    private String startTimeStr;

    private String endTimeStr;

    /**
     * 行程执行人
     */
    private Long executorUserId;

    @ApiModelProperty("查询行程日期")
    private String queryDate;
}
