package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:45
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportTemplateConfirmVO implements Serializable {

    @ApiModelProperty("报告id")
    private Long reportId;

    @ApiModelProperty("合格分数")
    private BigDecimal passScore;

    @ApiModelProperty("总分")
    private BigDecimal totalScore;

    @ApiModelProperty("报告统计")
    private List<CountResult> countResults;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class CountResult{
        @ApiModelProperty(value = "属性（0一般项 1红线项 2否决项 3加分项 4扣分项）")
        private Integer itemProperty;

        @ApiModelProperty("数量")
        private Integer count;

        @ApiModelProperty("是否合格（1-合格，0-不合格）")
        private Boolean passFlag;
    }

}
