package com.tll.inspect.rpc.vo.plan;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 交叉巡店计划列表查询-B端
 *
 * @author 齐燊登
 * @date 2025/06/05
 */
@Data
@ApiModel(description = "交叉巡店计划列表查询-B端")
public class CrossInspectPlanBackstageInfoVO implements Serializable {

    private Long id;

    @ApiModelProperty(value = "执行人ID")
    private Long executorId;

    @ApiModelProperty(value = "行程执行人", position = 1)
    private String executorName;

    @ApiModelProperty(value = "岗位", position = 2)
    private String position;

    @ApiModelProperty(value = "岗位ID")
    private String positionId;

    @ApiModelProperty(value = "所属部门", position = 3)
    private String department;

    @ApiModelProperty(value = "所属部门ID")
    private String departmentId;

    @ApiModelProperty(value = "行程计划状态: EXPIRED-已过期, EFFECTIVE-生效中, PENDING-待生效", position = 4)
    private String planStatus;

    @ApiModelProperty(value = "移交按钮是否可以操作")
    private Boolean isHandover=false;

    @ApiModelProperty(value = "开始时间", position = 5)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startDate;

    @ApiModelProperty(value = "结束时间", position = 6)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endDate;

    @ApiModelProperty(value = "可巡门店数", position = 7)
    private Integer storeCount=0;

    @ApiModelProperty(value = "必巡门店数", position = 8)
    private Integer requiredStoreCount;

    @ApiModelProperty(value = "已巡门店数", position = 9)
    private Integer finishStoreCount=0;

    @ApiModelProperty(value = "已计划待巡门店数", position = 10)
    private Integer waitStoreCount=0;

    @ApiModelProperty(value = "行程创建人", position = 11)
    private String creator;

    @ApiModelProperty(value = "行程创建时间", position = 12)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdTime;

    @ApiModelProperty(value = "行程编辑人", position = 13)
    private String updater;

    @ApiModelProperty(value = "行程编辑时间", position = 14)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime modifyTime;
    
    //门店列表
    @ApiModelProperty(value = "门店列表")
    private List<StoreSimpleInfoVO> storeList;
    

}
