package com.tll.inspect.rpc.vo.plan;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-05-30 16:52
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ExecutorsPageVO implements Serializable {


    @ApiModelProperty(value = "员工用户ID")
    private Long userId;


    @ApiModelProperty(value = "员工编号")
    private String code;


    @ApiModelProperty(value = "姓名")
    private String fullName;

    @ApiModelProperty(value = "职务", position = 3)
    private String duty;

    @ApiModelProperty(value = "完整组织层级",hidden = true)
    private String orgLevel;

    @ApiModelProperty("组织id")
    private Long orgId;

    @ApiModelProperty(value = "组织名称")
    private String orgName;

}
