package com.tll.inspect.rpc.vo.plan;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:52
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectPlanDetailLogVO implements Serializable {

    @ApiModelProperty("巡检计划ID")
    private Long planId;

    @ApiModelProperty("操作内容（0新建 1编辑 2移动 3启用 4禁用 5复制 6删除 7移交）")
    private Integer operationType;

    @ApiModelProperty("创建人id")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "备注")
    private String remark;

}
