package com.tll.inspect.rpc.vo.signin;

import com.tll.inspect.rpc.dto.signin.SignInAddDTO;
import com.tll.inspect.rpc.dto.signin.SignInAddDTO.Media;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:52
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInListVO implements Serializable {

    private Long id;

    @NotBlank(message = "定位地址不能为空")
    private String location;

    @ApiModelProperty(value = "经度",required = true)
    private Double longitude;

    @ApiModelProperty(value = "纬度",required = true)
    private Double latitude;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "巡检现场照片或者视频，可选")
    private List<Media> fileUrls;

    @ApiModelProperty("设备码")
    private String deviceCode;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Media {
        @ApiModelProperty("文件类型:0-图片,1-视频")
        private Integer fileType;

        @ApiModelProperty("链接")
        private String url;
    }
}
