package com.tll.inspect.rpc.vo.travel;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 行程执行人
 * @author zhaoshuai
 * @date 2025/6/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ExecutorRpcVO implements Serializable {
    private static final long serialVersionUID = -8648559471931403738L;

    /**
     * 员工id
     */
    @ApiModelProperty(value = "员工id")
    private Long id;

    /**
     * 员工编码
     */
    @ApiModelProperty(value = "员工编码")
    private String code;

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")
    private Long userId;

    /**
     * 登录号
     */
    @ApiModelProperty(value = "登录号")
    private String userName;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String gender;

    /**
     * 性别名称
     */
    @ApiModelProperty(value = "性别名称")
    private String genderName;

    /**
     * 员工类型
     */
    @ApiModelProperty(value = "员工类型")
    private String type;

    /**
     * 员工类型
     */
    @ApiModelProperty(value = "员工类型")
    private String typeName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务")
    private String duty;

    /**
     * 是否在职
     */
    @ApiModelProperty(value = "是否在职")
    private Boolean served;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String email;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private List<String> orgNames;

    /**
     * 领导员工id
     */
    @ApiModelProperty(value = "领导员工id")
    private Long leaderEmployeeId;

    @ApiModelProperty("员工行程")
    private List<TravelRpcVO> travelList;
}
