package com.tll.inspect.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 14:43
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInViewDTO {

    @ApiModelProperty(value = "签到开始时间",required = true)
    @NotNull(message = "开始时间不能为空")
    private LocalDateTime signInStartTime;

    @ApiModelProperty(value = "签到结束时间时间",required = true)
    @NotNull(message = "结束时间不能为空")
    private LocalDateTime signInEndTime;
}
