package com.tll.inspect.rpc.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import javax.persistence.Column;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-19 16:33
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportSubmitVO {

    @ApiModelProperty("状态码")
    private Integer code;

    @ApiModelProperty("提示内容")
    private String tipMessage;

    @ApiModelProperty("报告id")
    private Long reportId;

    @ApiModelProperty("模块id")
    private Long itemId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("总记录数")
    private Integer total;

    @ApiModelProperty("当前排序")
    private Integer sort;

    @ApiModelProperty("报告提交时间")
    private LocalDateTime commitTime;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty("巡检任务编号")
    private String inspectTaskNumber;
}
