package com.tll.inspect.rpc.vo;

import com.tll.inspect.rpc.dto.media.MediaDTO;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:45
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportTemplateItemPageVO implements Serializable {

    private Long id;

    @ApiModelProperty("报告id")
    private Long reportId;

    @ApiModelProperty("模板id")
    private Long templateId;

    @ApiModelProperty("门店编号")
    private String storeCode;

    @ApiModelProperty("模块名称")
    private String moduleName;

    @ApiModelProperty("巡检项id")
    private Long itemId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "巡检项内容(名称)")
    private String itemName;

    @ApiModelProperty(value = "属性（0一般项 1红线项 2否决项 3加分项 4扣分项）")
    private Integer itemProperty;

    @ApiModelProperty("评分标准")
    private String scoreStandard;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag;

    @ApiModelProperty("原因")
    private String reason;

    @ApiModelProperty("是否现场整改（1-是，0-否）")
    private Boolean rectifiedOnSite;

    @ApiModelProperty("得分")
    private BigDecimal score;

    @ApiModelProperty("巡检项分值")
    private BigDecimal totalScore;

    @ApiModelProperty("巡检现场照片或者视频")
    private List<MediaDTO> fileUrls;

    @ApiModelProperty("示例图")
    private List<MediaDTO> showUrls;

    @ApiModelProperty("排序")
    private BigDecimal sort;

    @ApiModelProperty("整改说明")
    private Boolean rectifiedRemark;

    @ApiModelProperty("整改图片")
    private List<MediaDTO> rectifiedUrls;

    @ApiModelProperty("完成数量")
    private Long finishTotal;

    @ApiModelProperty("页面文字说明，图片视频 ,界面的显示配置")
    private List<InspectItemRuleScoreVO> pageConfig;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public class InspectItemRuleScoreVO  implements Serializable {

        @ApiModelProperty("巡检项ID")
        private Long itemId;

        @ApiModelProperty(value = "配置项类型（1文字说明 2图片视频）")
        private Integer ruleType;

        @ApiModelProperty(value = "配置项条件（1合格 2不合格 3整改）")
        private Integer ruleCondition;

        @ApiModelProperty(value = "是否显示（0不显示 1显示）")
        private Boolean display;

        @ApiModelProperty(value = "是否必填（0不必填 1必填），当rule=3时，0从本地相册选择,1现场拍照")
        private Boolean required;

    }
}
