package com.tll.inspect.rpc.vo.plan;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:52
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectPlanDetailVO implements Serializable {

    @ApiModelProperty(value = "计划ID")
    private Long id;

    @ApiModelProperty(value = "执行人ID")
    private Long executorId;

    @ApiModelProperty(value = "执行人姓名")
    private String executorName;

    @ApiModelProperty("指派人id")
    private Long createUserId;

    @ApiModelProperty("指派人姓名")
    private String creator;

    @ApiModelProperty("指派时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "必巡门店数")
    private Integer requiredStoreCount;

    @ApiModelProperty(value = "指派可巡门店总数")
    private Integer storeCount;

    @ApiModelProperty(value = "已巡门店数")
    private Integer finishStoreCount;

    @ApiModelProperty(value = "已计划待巡门店数")
    private Integer waitStoreCount;

    @ApiModelProperty("门店id")
    private List<String> storeCodes;

    @ApiModelProperty(value = "行程时间(开始日期)")
    private LocalDate startDate;

    @ApiModelProperty(value = "行程时间(结束日期)")
    private LocalDate endDate;
}
