package com.tll.inspect.rpc.vo.report;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 巡检报告列表查询参数
 * @author zhaoshuai
 * @date 2025/6/18
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "巡检报告列表查询参数")
public class InspectReportListQueryRpcDTO extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = 3963985018101122322L;

    @ApiModelProperty("巡检报告状态tab查询条件（1整改中，2已完结）")
    private Integer rectificationStatus;

    @ApiModelProperty("巡检结果（全部，合格，不合格）")
    private Boolean passFlag;

    @ApiModelProperty("开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "门店codes，内部使用，不暴露给接口文档", hidden = true)
    private List<String> storeCodes;

    //门店：按门店编号，门店名称，法人名称，法人手机号，查询范围为对应门店的巡检报告
    @ApiModelProperty("门店信息搜索条件")
    private String storeCondition;

    //巡检人：支持输入员工姓名查询，查询范围为员工作为巡检人的巡检报告
    @ApiModelProperty("巡检人搜索条件")
    private String executorCondition;

    //门店负责人：支持输入员工姓名查询，查询范围为员工作为门店的负责人（督导，区域经理，省经理，大区经理）的门店的巡检报告
    @ApiModelProperty("门店负责人搜索条件")
    private String personCondition;
}
