package com.tll.inspect.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.inspect.Application;
import com.tll.inspect.rpc.dto.InspectReportDetailQueryRpcDTO;
import com.tll.inspect.rpc.vo.report.InspectReportDetailRpcVO;
import com.tll.inspect.rpc.vo.report.InspectReportListQueryRpcDTO;
import com.tll.inspect.rpc.vo.report.InspectReportListRpcVO;
import com.tll.inspect.rpc.vo.report.InspectReportOverViewRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 巡检报告rpc服务（C端）
 */
@FeignClient(name = Application.NAME, path = InspectReportRpcService.URI)
@Validated
public interface InspectReportRpcService {

    String URI = Application.URI_PREFIX + "/report";

    @PostMapping("/pageList")
    @ApiOperation("巡检报告列表")
    ApiResult<PagingVO<InspectReportListRpcVO>> pageList(@RequestBody InspectReportListQueryRpcDTO dto);

    @PostMapping("/queryReportOverview")
    @ApiOperation("巡检报告概览")
    ApiResult<InspectReportOverViewRpcVO> queryReportOverview(@RequestBody InspectReportDetailQueryRpcDTO dto);

    @PostMapping("/queryReportDetail")
    @ApiOperation("巡检报告详情")
    ApiResult<InspectReportDetailRpcVO> queryReportDetail(@RequestBody InspectReportDetailQueryRpcDTO rpcDTO);
}