package com.tll.inspect.rpc.dto.travel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * title:
 * author: zq
 * create: 2025-06-10 13:59
 **/
@Data
@ApiModel(description = "执行人行程列表rpc入参")
@Builder
public class UserTravelListRpcDTO implements Serializable {

    private static final long serialVersionUID = -7311164256927128481L;

    @ApiModelProperty("员工ids")
    private List<Long> userIds;

    @ApiModelProperty("员工姓名")
    private String userName;

    @ApiModelProperty("行程时间")
    private String travelDate;

    @ApiModelProperty("行程类型（0其他 1赶路 2返程 3活动到店 4门店巡检 5休假")
    private Integer travelType;

}