package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-06-17 15:30
 * @description
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class FormDetailVO {

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long id;

    /**
     * 表单所属部门id
     */
    @ApiModelProperty(value = "表单所属部门id")
    private Long departmentId;

    /**
     * 表单所属部门名称
     */
    @ApiModelProperty(value = "表单所属部门名称")
    private String departmentName;

    /**
     * 表单id
     */
    @ApiModelProperty(value = "表单id")
    private String formId;

    /**
     * 表单名称
     */
    @ApiModelProperty(value = "表单名称")
    private String formName;

    /**
     * 表单分类：1-任务表单，2-巡检表单
     */
    @ApiModelProperty(value = "表单分类：1-任务表单，2-巡检表单")
    private List<Integer> formTypes;

    /**
     * 表单状态：0-草稿，2-空闲，3-待启用，4-启用中，5-已使用
     */
    @ApiModelProperty(value = "表单状态：0-草稿，2-空闲，3-待启用，4-启用中，5-已使用")
    private Integer formStatus;

    /**
     * 表单项集合
     */
    @ApiModelProperty(value = "表单项集合")
    private List<FormItemVO> formItems;

    /**
     * 报告ID
     */
    @ApiModelProperty("报告ID")
    private Long reportId;
}
