package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @author  XieBeiChen
 * @date  2025-06-12 13:45
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class ReportConfirmVO implements Serializable {

    @ApiModelProperty("报告id")
    private Long reportId;

    @ApiModelProperty("合格分数")
    private BigDecimal passScore;

    @ApiModelProperty("总分")
    private BigDecimal totalScore;

    @ApiModelProperty("不合格项总数")
    private Integer unPassTotal;

    @ApiModelProperty("报告提交时间")
    private LocalDateTime commitTime;

    @ApiModelProperty("报告总结")
    private String reportSummary;

    @ApiModelProperty("整改到期时间")
    private LocalDateTime dueTime;

    @ApiModelProperty("报告统计")
    private List<CountResult> countResults;

    @ApiModelProperty("表单信息")
    private FormDetailVO formDetailVO;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class CountResult{
        @ApiModelProperty(value = "属性（0一般项 1红线项 2否决项 3加分项 4扣分项）")
        private Integer itemProperty;

        @ApiModelProperty("合格总数")
        private Integer passCount;

        @ApiModelProperty("不合格总数")
        private Integer failCount;
    }



}
