package com.tll.inspect.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 14:43
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInViewVO implements Serializable {

    @ApiModelProperty("签到数据")
    private List<SignItem> signItems;

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class SignItem{
        @ApiModelProperty("日期")
        private String date;

        @ApiModelProperty("签到标识")
        private Boolean signFlag;

        @ApiModelProperty("请假标识")
        private Boolean vacationFlag;
    }

}
