package com.tll.inspect.rpc.vo.report;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 巡检报告详情返回
 * @author zhaoshuai
 * @date 2025/6/18
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class InspectReportDetailItemVO implements Serializable {

    //巡检项序号、项分数、巡检项内容、评分标准、示例图、合格状态、项属性、得分、巡检说明（合格、不合格原因）
    //合格、不合格返图、整改说明、整改返图

    @ApiModelProperty("巡检项id")
    private Long itemId;

    @ApiModelProperty("巡检项编号")
    private String itemCode;

    @ApiModelProperty("项分数")
    private BigDecimal itemScore;

    @ApiModelProperty("巡检项序号")
    private Integer itemSort;

    @ApiModelProperty("项目内容")
    private String itemName;

    @ApiModelProperty("评分标准")
    private String scoreStandard;

    @ApiModelProperty("合格状态")
    private Boolean passFlag;

    @ApiModelProperty(value = "属性（0一般项 1红线项 2否决项 3加分项 4扣分项）")
    private Integer itemProperty;

    @ApiModelProperty("得分")
    private BigDecimal score;

    @ApiModelProperty("巡检项合格/不合格说明（原因）")
    private String reason;

    @ApiModelProperty("整改项文字说明")
    private String rectDescription;

    @ApiModelProperty("示例图")
    private List<String> picUrls;

    @ApiModelProperty("不合格返图")
    private List<String> failPicUrls;

    @ApiModelProperty("整改返图")
    private List<String> rectPicUrls;

}
