package com.tll.inspect.rpc.vo.report;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 巡检报告预览巡检项VO
 * @author zhaoshuai
 * @date 2025/6/19
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "巡检报告预览巡检项VO")
public class ReportOverviewItemVO {

    @ApiModelProperty("整改巡检项id")
    private Long itemId;

    @ApiModelProperty("巡检项编号")
    private String itemCode;

    @ApiModelProperty("整改项整改状态")
    private Integer status;

    @ApiModelProperty("是否合格（1-合格，0-不合格）")
    private Boolean passFlag ;

    @ApiModelProperty("项属性")
    private Integer itemProperty;

    @ApiModelProperty("项目内容")
    private String itemName;

    @ApiModelProperty("评分标准")
    private String scoreStandard;

    @ApiModelProperty("得分")
    private BigDecimal score;

    @ApiModelProperty("巡检模板模块id")
    private Long moduleId;

    @ApiModelProperty("巡检模板模块名")
    private String moduleName;

    @ApiModelProperty("不合格原因")
    private String reason;


    @ApiModelProperty("示例图")
    private List<String> picUrls;

    @ApiModelProperty("不合格返图")
    private List<String> failPicUrls;

}
