package com.tll.inspect.rpc.vo.signin;

import com.tll.inspect.rpc.vo.media.MediaVO;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author XieBeiChen
 * @date 2025-06-04 13:52
 * @description
 */
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Data
public class SignInAppPageVO implements Serializable {

    private Long id;

    private String location;

    private Double longitude;

    private Double latitude;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("设备码")
    private String deviceCode;

   @ApiModelProperty("门店编码")
    private String storeCode;

   @ApiModelProperty("打卡数据来源:1-打卡，2-到店签到，3-离店签退")
    private Integer source;

    @ApiModelProperty(value = "巡检现场照片或者视频，可选")
    private List<MediaVO> fileUrls;

    @ApiModelProperty("打卡时间")
    private LocalDateTime createTime;


}
